local fn = {}

-- shortcut for code like `ThePlayer and ThePlayer.replica and ThePlayer.replica.inventory`
local function Get(head_node, ...)
	local current_node = head_node
	for _, key in ipairs({ ... }) do
		if not current_node then
			return
		end

		local next_node = current_node[key]
		if type(next_node) == "function" then -- for code like `ThePlayer.replica.inventory:GetActiveItem()`
			current_node = next_node(current_node) -- this could be `false`/`nil` so avoid assigning with `and or`
		else
			current_node = next_node
		end
	end
	return current_node
end

local get_teleport_command_str = function(x, z)
	local command_str = [[
local player = ConsoleCommandPlayer()
local drownable = player and player.components.drownable
local health = player and player.components.health
local overwater = not TheWorld.Map:IsVisualGroundAtPoint(x, 0, z) and TileGroupManager and not TileGroupManager:IsInvalidTile(TheWorld.Map:GetTileAtPoint(x, 0, z)) and TheWorld.Map:GetPlatformAtPoint(x, z) == nil
if not overwater or (health and health.invincible) or not (drownable and drownable.enabled) then
	c_teleport(x, 0, z)
	if player.SnapCamera then
		player:SnapCamera()
	end
end
]]
	return string.format("local x, z = %d, %d;", x, z) .. command_str
end
local function DoTeleport(x, z)
	if TheWorld and TheWorld.ismastersim then
		ExecuteConsoleCommand(get_teleport_command_str(x, z))
	else
		TheNet:SendRemoteExecute(get_teleport_command_str(x, z), x, z)
	end
end

fn.KEY_MAP_TELEPORT = function()
	local screen = Get(TheFrontEnd, "GetActiveScreen")
	if
		Get(TheNet, "GetIsServerAdmin") -- playing as admin
		and Get(ThePlayer, "player_classified", "isfreebuildmode", "value") -- creative mode enabled
		and tostring(screen) == "MapScreen" -- is on map screen
		and Get(screen, "GetWorldPositionAtCursor") -- function available
	then
		local x, _, z = screen:GetWorldPositionAtCursor()
		Get(ThePlayer, "components", "ngl_pathfollower", "ForceStop")
		ThePlayer:DoTaskInTime(0.5, function()
			DoTeleport(x, z)
		end)
	end
end

fn.KEY_MAP_SOUL_HOP = function()
	local screen = Get(TheFrontEnd, "GetActiveScreen")
	if
		tostring(screen) == "MapScreen" -- is on map screen
		and Get(screen, "GetWorldPositionAtCursor") -- function available
	then
		local x, _, z = screen:GetWorldPositionAtCursor()
		Get(ThePlayer, "components", "ngl_pathfollower", "ForceStop")
		local controller = Get(ThePlayer, "components", "playercontroller")
		return controller and controller:OnMapAction(ACTIONS.BLINK_MAP.code, Vector3(x, 0, z))
	end
end

return fn
