local Widget = require "widgets/widget"

--the test of doubleclick
local DBCLICK_TIME_THRESHOLD = GetModConfigData("DBCLICK_TIME_THRESHOLD") or 0.3
local DBCLICK_DIST_THRESHOLD = 25
-- delay to check click after open the map
local VALIDCLICK_TIME_THRESHOLD = 0.1

-- for additional travel
local ad_travel_keystr = GetModConfigData("KEY_ADDITION_TRAVEL")
local CONTROL_ADDITIONAL_TRAVEL = ad_travel_keystr and rawget(GLOBAL, ad_travel_keystr) or nil

local PathLineGroup = require "widgets/ngl_pathlinegroup"
local DestIcon = require "widgets/ngl_desticon"

-- DEPRECATED
-- --some actions maybe added in other mod triggered by combinekey + rightclick
-- --** use controlpress instead to avoid the case of key stick(the key keep on down and not released )
-- function IsCombineKeyPressed()
-- 	--return TheInput:IsKeyDown(KEY_LALT) or TheInput:IsKeyDown(KEY_LCTRL) or TheInput:IsKeyDown(KEY_LSHIFT)
-- 	return TheInput:IsControlPressed(CONTROL_FORCE_INSPECT) or TheInput:IsControlPressed(CONTROL_FORCE_ATTACK) or TheInput:IsControlPressed(CONTROL_FORCE_TRADE) or TheInput:IsControlPressed(CONTROL_FORCE_STACK)
-- end

-- function IsTriggerControlPressed(control)
-- 	if TheInput:ControllerAttached() then --game controller mode
-- 		return control == CONTROL_INSPECT
-- 	else -- mouse and keyboard mode
-- 		return control == CONTROL_SECONDARY --and not IsCombineKeyPressed()
-- 	end
-- 	return false
-- end

--screenPos: original point(0,0) is center point
local function WorldPosToScreenPos(self, x, z)
	local screen_width, screen_height = TheSim:GetScreenSize() -- 1920, 1080
	local half_x, half_y = RESOLUTION_X / 2, RESOLUTION_Y / 2 -- 1280/2, 720/2
	local map_x, map_y = TheWorld.minimap.MiniMap:WorldPosToMapPos(x, z, 0) -- Converts world position to map position
	local screen_x = ((map_x * half_x) + half_x) / RESOLUTION_X * screen_width -- Centers map point onto middle of map screen
	local screen_y = ((map_y * half_y) + half_y) / RESOLUTION_Y * screen_height
	return screen_x, screen_y
end

local NO_TRIGGER_TRAVEL_MODIFIER_CONTROLS = {
	[CONTROL_FORCE_ATTACK] = true, 	-- Ctrl
	[CONTROL_FORCE_TRADE] = true, 	-- Shift
	[CONTROL_FORCE_INSPECT] = true 	-- Alt
}
if CONTROL_ADDITIONAL_TRAVEL ~= nil then
	NO_TRIGGER_TRAVEL_MODIFIER_CONTROLS[CONTROL_ADDITIONAL_TRAVEL] = false
end

-- returns : is travel control clicked(true/false),  is additional travel(true/false)
-- set it as global function so that minimap/smallmap postinit can use it
function CheckClickedAndGetTravelType(control)
	local travel_control_pressed
	if TheInput:ControllerAttached() then --game controller mode
		travel_control_pressed = (control == CONTROL_INSPECT)
	else -- mouse and keyboard mode
		travel_control_pressed = (control == CONTROL_SECONDARY) --and not IsCombineKeyPressed()
	end
	if not travel_control_pressed then return false, false end

	for k,v in pairs(NO_TRIGGER_TRAVEL_MODIFIER_CONTROLS) do
		if v and TheInput:IsControlPressed(k) then
			return false, false -- override as false to avoid conflict with other mod which has map rightclick action
		end
	end

	return true, (CONTROL_ADDITIONAL_TRAVEL ~= nil and TheInput:IsControlPressed(CONTROL_ADDITIONAL_TRAVEL))
end

local function CanOverrideMapAction(map_action)
	return not (map_action and map_action.action and map_action.action.closes_map) -- nil action or action that not closes map
end

local function GetCurrentTime()
	-- return GetStaticTime()
	return os.clock() -- to handle time scale change
end

-- SINGLECLICK : AUTOWALK
-- DOUBLECLICK : ORIGINAL SINGLECLICK FUNCTION
-- we should tweak to make it work in main mapscreen
local function AddAutoMoveTrigger(self)

	-------------------------MOUSECLICK TRIGGER-----------------------
	--store the info about lastclick to test whether it's doubleclick this time
	self.lastactive_time = 0

	self.lastrightclick_time = 0
	self.lastrightclick_pos = Vector3(0,0,0)

	local old_OnBecomeActive = self.OnBecomeActive
	self.OnBecomeActive = function(self)
		self.lastactive_time = GetCurrentTime()
		return old_OnBecomeActive(self)
	end

	local old_OnControl = self.OnControl
	self.OnControl = function (self, control, down)
		-- trigger way of keyboard
		local is_trigger_clicked, is_additional_travel = CheckClickedAndGetTravelType(control)
		if down and GetCurrentTime()-self.lastactive_time > VALIDCLICK_TIME_THRESHOLD and is_trigger_clicked then
			local current_click_time = GetCurrentTime()
			local current_click_pos = TheInput:GetScreenPosition()
			local topscreen = TheFrontEnd:GetActiveScreen()
			if topscreen and topscreen.GetWorldPositionAtCursor ~= nil then
				local x, _, z = topscreen:GetWorldPositionAtCursor()
				local LMBaction, RMBaction = nil, nil
				if self.UpdateMapActions then
					LMBaction, RMBaction = self:UpdateMapActions(x, 0, z)
				end
				local travelled = false

				if ThePlayer.components.ngl_pathfollower
					and CanOverrideMapAction(RMBaction) then
					local target_pos = Vector3(x, 0, z)
					ThePlayer.components.ngl_pathfollower:Travel(target_pos, is_additional_travel)
					travelled = true
				end
				self.lastrightclick_time = current_click_time
				self.lastrightclick_pos = current_click_pos
				if not travelled then
					return old_OnControl and old_OnControl(self, control, down)
				else
					return true
				end
			end
		else -- other controls
			return old_OnControl and old_OnControl(self, control, down)
		end
	end

end

local function AddPathWidgets(self)
	------------------------POSITON TRANSFROM FUNCTIONS-----------------------------
	if self.WorldPosToScreenPos == nil then
		self.WorldPosToScreenPos = WorldPosToScreenPos
	end
	-------------------------PAINT WIDGET(ROOT)-------------------------------
	self.paintWidget = self:AddChild(Widget("PaintWidget"))
	-- local mapsize_w ,mapsize_h = TheSim:GetScreenSize()
	--self.paintWidget:SetScissor(-mapsize_w/2,-mapsize_h/2,mapsize_w,mapsize_h)
	------------------------SHOW PATH LINES(CHILD)-----------------------------
	-- add pathline widget
	--self.pathLineGroup = self:AddChild(PathLineGroup(self,"images/plantregistry.xml","details_line.tex"))

	local ui_settings_str = GetModConfigData("UI_DISPLAY")
	local pathline_enabled = ui_settings_str == "Both" or ui_settings_str == "PathLine"
	local desticon_enabled = ui_settings_str == "Both" or ui_settings_str == "DestIcon"
	if pathline_enabled then
		self.pathLineGroup = self.paintWidget:AddChild(PathLineGroup(self,line_xml,line_texName))
		self.pathLineGroup:SetLineTint(1,1,1,0.8)
		self.pathLineGroup:SetLineDefaultHeight(40)
	end

	-----------------------SHOW DEST ICON(CHILD)------------------------------
	if desticon_enabled then
		self.destIconImage = self.paintWidget:AddChild(DestIcon(self,icon_xml,icon_texName))
		self.destIconImage:SetDefaultScale(0.7)
	end
end

-- DISPLAY TWEAK IN mapwidget
AddClassPostConstruct("widgets/mapwidget", AddPathWidgets)

-- TRIGGER TWEAK IN mapscreen
local maps_trigger_str = GetModConfigData("MAPS_TRIGGER")
local mainmap_trigger_enabled = (maps_trigger_str == "Both") or (maps_trigger_str == "MainMap")
if mainmap_trigger_enabled then
	AddClassPostConstruct("screens/mapscreen", AddAutoMoveTrigger)
end
