local function T(en, zh, zht) return ChooseTranslationTable({ en, zh = zh, zht = zht or zh }) end

name = T('Boss Calendar Lite', 'Boss 日历', 'Boss 日曆')
author = T('Boas, xaT2x, iaman2b & liolok', 'Boas、xaT2x、iaman2b & 李皓奇')
local date = '2025-09-03'
version = date .. '' -- for revision in same day
description = T(
  [[Calculate and remember when bosses respawn.
Support click-announcing and auto-reminding.
Also support binding key at bottom of Settings > Controls page.]],
  [[帮你计算并记住 Boss 们什么时候刷新。
支持点击宣告、自动提醒。
也支持在设置 > 控制页面底部实时调整键位绑定。]],
  [[幫你計算並記住 Boss 們何時刷新。
支援點擊宣告、自動提醒。
也支援在設定 > 控制頁面底部即時調整鍵位綁定。]]
) .. '\n󰀰 ' .. date -- Florid Postern（绚丽之门）
api_version = 10
dst_compatible = true
client_only_mod = true
icon = 'modicon.tex'
icon_atlas = 'modicon.xml'

local keyboard = { -- from STRINGS.UI.CONTROLSSCREEN.INPUTS[1] of strings.lua, need to match constants.lua too.
  { 'F1', 'F2', 'F3', 'F4', 'F5', 'F6', 'F7', 'F8', 'F9', 'F10', 'F11', 'F12', 'Print', 'ScrolLock', 'Pause' },
  { '1', '2', '3', '4', '5', '6', '7', '8', '9', '0' },
  { 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M' },
  { 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z' },
  { 'Escape', 'Tab', 'CapsLock', 'LShift', 'LCtrl', 'LSuper', 'LAlt' },
  { 'Space', 'RAlt', 'RSuper', 'RCtrl', 'RShift', 'Enter', 'Backspace' },
  { 'BackQuote', 'Minus', 'Equals', 'LeftBracket', 'RightBracket' },
  { 'Backslash', 'Semicolon', 'Quote', 'Period', 'Slash' }, -- punctuation
  { 'Up', 'Down', 'Left', 'Right', 'Insert', 'Delete', 'Home', 'End', 'PageUp', 'PageDown' }, -- navigation
}
local numpad = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'Period', 'Divide', 'Multiply', 'Minus', 'Plus' }
local mouse = { '\238\132\130', '\238\132\131', '\238\132\132' } -- Middle Mouse Button, Mouse Button 4 and 5
local key_disabled = { description = 'Disabled', data = 'KEY_DISABLED' }
keys = { key_disabled }
for i = 1, #mouse do
  keys[#keys + 1] = { description = mouse[i], data = mouse[i] }
end
for i = 1, #keyboard do
  for j = 1, #keyboard[i] do
    local key = keyboard[i][j]
    keys[#keys + 1] = { description = key, data = 'KEY_' .. key:upper() }
  end
  keys[#keys + 1] = key_disabled
end
for i = 1, #numpad do
  local key = numpad[i]
  keys[#keys + 1] = { description = 'Numpad ' .. key, data = 'KEY_KP_' .. key:upper() }
end

local function Header(...) return { name = T(...), options = { { description = '', data = 0 } }, default = 0 } end

configuration_options = {
  {
    name = 'key_to_view',
    label = T('View Key', '查看按键', '查看按鍵'),
    hover = T(
      'Bind a key, press and hold to view calendar.',
      '绑定一个按键，按住查看日历。',
      '綁定一個按鍵，按住查看日曆。'
    ),
    options = keys,
    default = 'KEY_V',
  },
  {
    name = 'calendar_font_size',
    label = T('Font Size', '字体大小', '字體大小'),
    hover = T('How big should the calendar text be?', '日历文本要多大？', '日曆文字要多大？'),
    options = {
      { data = 24, description = '24' },
      { data = 26, description = '26' },
      { data = 28, description = '28' },
      { data = 30, description = '30' },
      { data = 32, description = '32' },
    },
    default = 28,
  },

  Header('Time Style', '时间格式', '時間格式'),
  {
    name = 'calendar_time_style',
    label = T('Calendar', '日历', '日曆'),
    hover = T(
      'How respawn time shows up in calendar.',
      '日历中如何显示刷新时间',
      '日曆中如何顯示刷新時間'
    ),
    options = { -- function names from BossCalendar class
      {
        data = 'AbsoluteGameDay',
        description = T('World Day', '世界天数', '世界天數'),
        hover = T('Day 21.10', '第 21.10 天'),
      },
      {
        data = 'CountdownGameDays',
        description = T('Days to Go', '倒计天数', '倒數天數'),
        hover = T('19.99d', '19.99 天'),
      },
      { data = 'CountdownRealTime', description = T('Real Time', '现实时间', '現實時間'), hover = 'hh:mm:ss' },
    },
    default = 'CountdownGameDays',
  },
  {
    name = 'announce_time_style',
    label = T('Announce', '宣告'),
    hover = T('How to announce respawn time.', '如何宣告刷新时间', '如何宣告刷新時間'),
    options = { -- function names from BossCalendar class
      {
        data = 'AbsoluteGameDay',
        description = T('World Day', '世界天数', '世界天數'),
        hover = T(
          'Dragonfly will repsawn on day 21.10.',
          '龙蝇将在第 21.10 天刷新。',
          '龍蠅將在第 21.10 天刷新。'
        ),
      },
      {
        data = 'CountdownGameDays',
        description = T('Days to Go', '倒计天数', '倒數天數'),
        hover = T(
          'Dragonfly will repsawn in 19.99 days.',
          '龙蝇将在 19.99 天之后刷新。',
          '龍蠅將在 19.99 天之後刷新。'
        ),
      },
      {
        data = 'CountdownRealTime',
        description = T('Real Time', '现实时间', '現實時間'),
        hover = T(
          'Dragonfly will repsawn in 1 hour 30 minutes.',
          '龙蝇将在 1 小时 30 分钟之后刷新。',
          '龍蠅將在 1 小時 30 分鐘之後刷新。'
        ),
      },
    },
    default = 'AbsoluteGameDay',
  },

  Header('Remind', '提醒'),
  {
    name = 'remind_position',
    label = T('Position', '位置'),
    hover = T('Where should message appear?', '消息出现在哪里？', '訊息出現在哪裡？'),
    options = {
      {
        data = 'chat',
        description = T('Chat', '聊天'),
        hover = T(
          'Message shows up in chat history, visible to yourself only.',
          '消息出现在聊天记录，仅对你自己可见。',
          '訊息出現在聊天記錄，僅對你自己可見。'
        ),
      },
      {
        data = 'head',
        description = T('Head', '头顶', '頭頂'),
        hover = T(
          'Message shows upon your player character.',
          '消息出现在你的玩家角色上方。',
          '訊息出現在你的玩家角色上方。'
        ),
      },
    },
    default = 'chat',
  },
  {
    name = 'remind_color',
    label = T('Color', '颜色', '顏色'),
    hover = T('Choose a color for message text.', '选择消息文本颜色', '選擇訊息文本顏色'),
    options = { -- will use PLAYERCOLOURS from constants.lua
      { data = 'RED', description = T('Red', '红', '紅') },
      { data = 'BLUE', description = T('Blue', '蓝', '藍') },
      { data = 'PURPLE', description = T('Purple', '紫') },
      { data = 'ORANGE', description = T('Orange', '橙') },
      { data = 'YELLOW', description = T('Yellow', '黄', '黃') },
      { data = 'GREEN', description = T('Green', '绿', '綠') },
    },
    default = 'GREEN',
  },
  {
    name = 'talk_duration',
    label = T('Duration', '持续时间', '持續時間'),
    hover = T(
      'How long does head message last? (not for chat message)',
      '头顶消息持续多久？（不管聊天消息）',
      '頭頂訊息持續多久？（不管聊天訊息）'
    ),
    options = {
      { data = 3, hover = '3s', description = T('Short', '更短') },
      { data = 5, hover = '5s', description = T('Default', '默认', '預設') },
      { data = 7, hover = '7s', description = T('Long', '更久') },
    },
    default = 5,
  },
}
