local G = GLOBAL
local DROP = G.ACTIONS.DROP

local function Drop(x, z, ...)
  local target, isreleased = nil, true
  G.SendRPCToServer(G.RPC.LeftClick, DROP.code, x, z, target, isreleased, ...)
end

AddComponentPostInit('playercontroller', function(self, inst)
  if inst ~= G.ThePlayer then return end

  local OldOnLeftClick = self.OnLeftClick
  self.OnLeftClick = function(self, down)
    if not down then return OldOnLeftClick(self, down) end
    local act = self:GetLeftMouseAction()
    local item = inst and inst.replica and inst.replica.inventory and inst.replica.inventory:GetActiveItem()
    if not (act and act.action == DROP and item) then return OldOnLeftClick(self, down) end
    local pos = G.TheInput:GetWorldPosition()
    local x, z = math.floor(pos.x) + 0.5, math.floor(pos.z) + 0.5 -- align to wall grid
    local controlmods = self:EncodeControlMods()
    if self:CanLocomote() then -- forest-only world
      local act = G.BufferedAction(inst, nil, DROP, item, G.Vector3(x, 0, z))
      act.options.wholestack = not G.TheInput:IsControlPressed(G.CONTROL_FORCE_STACK)
      act.preview_cb = function() Drop(x, z, controlmods, nil, act.action.mod_name) end
      self:DoAction(act)
    else -- forest-cave world
      Drop(x, z, controlmods)
    end
  end
end)
