local G = GLOBAL
local LOOKAT = G.ACTIONS.LOOKAT
local SendRPC = G.SendRPCToServer
local InspectButton = G.RPC.InspectButton

AddComponentPostInit('playercontroller', function(self, inst)
  if inst ~= G.ThePlayer then return end

  local OldOnLeftClick = self.OnLeftClick
  function self:OnLeftClick(down)
    local act = self:GetLeftMouseAction()
    local action = act and act.action
    local target = act and act.target

    if down and action == LOOKAT and target and target:HasTag('player') then
      return SendRPC(InspectButton, target)
    else
      return OldOnLeftClick(self, down)
    end
  end
end)
