local function T(en, zh, zht) return ChooseTranslationTable({ en, zh = zh, zht = zht or zh }) end

name = T('Show Player Name', '显示玩家名字')
author = T('wildcheri, liolok', 'wildcheri、李皓奇')
local date = '2025-12-27'
version = date .. '' -- for revision in same day
description = T(
  'Special name color for everyone, picked from player list in "Scoreboard".',
  '每个人都有专属的名字颜色，取自「计分板」里的玩家列表。'
) .. '\n󰀰 ' .. T('Last Updated at: ', '最后更新于：') .. date
api_version = 10
dst_compatible = true
client_only_mod = true

configuration_options = {
  {
    name = 'text_font',
    label = T('Text Font', '文本字体'),
    options = {
      { data = 'UIFONT', description = T('UI Font', '通用界面字体') },
      { data = 'CHATFONT_OUTLINE', description = T('Chat Message Font', '聊天消息字体') },
      { data = 'TALKINGFONT', description = T('General Character Talking Font', '通用角色台词字体') },
      { data = 'TALKINGFONT_WORMWOOD', description = T('Wormwood Talking Font', '沃姆伍德台词字体') },
      { data = 'TALKINGFONT_TRADEIN', description = T('Tradein Talking Font', '交易小店台词字体') },
      { data = 'TALKINGFONT_HERMIT', description = T('Hermit Talking Font', '寄居蟹隐士台词字体') },
    },
    default = 'TALKINGFONT',
  },
  {
    name = 'text_size',
    label = T('Text Size', '文本字号'),
    options = {
      { data = 26, description = '26' },
      { data = 28, description = '28' },
      { data = 30, description = '30' },
    },
    default = 28,
  },
  {
    name = 'show_self',
    label = T('Your Name', '你的名字'),
    options = {
      { data = false, description = T('Hide', '隐藏') },
      { data = true, description = T('Show', '显示') },
    },
    default = false,
  },
}
