local FollowText = require('widgets/followtext')

local T = TUNING.LIOLOK_SHOW_PLAYER_NAME or {}

local last_updated_offset = T.OFFSET or 100

return function(player) -- for AddPlayerPostInit
  if TheWorld.ismastersim and TheNet:GetServerIsDedicated() then return end

  player:DoStaticTaskInTime(0.2, function()
    if not ThePlayer then return end

    local font = rawget(_G, T.TEXT_FONT or 'TALKINGFONT')
    local size = T.TEXT_SIZE or 28
    local widget = ThePlayer.HUD:AddChild(FollowText(font, size))
    if player == ThePlayer and not T.SHOW_SELF then widget:Hide() end

    widget:SetHUD(ThePlayer.HUD.inst)
    widget:SetTarget(player)
    widget:SetOffset(Vector3(0, last_updated_offset, 0))

    local color = player.playercolour or DEFAULT_PLAYER_COLOUR
    widget.text:SetColour(unpack(color))

    local OldOnUpdate = widget.OnUpdate
    widget.OnUpdate = function(self, ...)
      OldOnUpdate(self, ...)
      local ctl = ThePlayer and ThePlayer.components and ThePlayer.components.playercontroller
      if not (ctl and player and self.text) then return end

      local lmb = ctl:GetLeftMouseAction()
      local is_target = player == (lmb and lmb.target or ctl:GetControllerTarget())
      local can_see = player.entity and player.entity:IsVisible() and CanEntitySeeTarget(ThePlayer, player)
      local name = (not is_target and can_see) and (player:GetDisplayName() or player.name) or ''
      self.text:SetString(name)
      if T.DEBUG then
        self.text:SetFont(rawget(_G, T.TEXT_FONT or 'TALKINGFONT'))
        self.text:SetSize(T.TEXT_SIZE or 28)
        local offset = T.OFFSET or 100
        if offset ~= last_updated_offset then
          last_updated_offset = offset -- update first to guard function call below
          self:SetOffset(Vector3(0, offset, 0))
        end
        if player == ThePlayer then
          if T.SHOW_SELF then
            self:Show()
          else
            self:Hide()
          end
        end
      end
    end

    player.liolok_player_name_widget = widget
  end)
end
