return function(self, player) -- to hook up `playercontroller` component
  if player ~= ThePlayer then return end

  local OldGetLeftMouseAction = self.GetLeftMouseAction
  function self:GetLeftMouseAction()
    local act = OldGetLeftMouseAction(self)
    if
      act
      and act.action == ACTIONS.LOOKAT -- replace regular inspect
      and not TheInput:IsControlPressed(CONTROL_FORCE_INSPECT) -- allow force inspect
    then
      act.action = ACTIONS.WALKTO
      self.LMBaction = act
    end
    return act
  end

  local OldOnLeftClick = self.OnLeftClick
  function self:OnLeftClick(down)
    local act = self:GetLeftMouseAction()
    local action = act and act.action
    local pos = act and act.target and act.target:GetPosition()
    if
      not (down and action == ACTIONS.WALKTO and pos)
      or TheInput:GetHUDEntityUnderMouse()
      or (ThePlayer and ThePlayer.replica and ThePlayer.replica.inventory and ThePlayer.replica.inventory:GetActiveItem())
      or self:IsAOETargeting()
      or self.placer_recipe
    then
      return OldOnLeftClick(self, down)
    end

    local function SendWalkRPC()
      return SendRPCToServer(
        RPC.LeftClick,
        action.code,
        pos.x,
        pos.z,
        nil, -- target
        true -- isreleased
      )
    end
    if not self:CanLocomote() then return SendWalkRPC() end -- movement prediction disabled

    local buffered_action = BufferedAction(ThePlayer, nil, action, nil, pos)
    buffered_action.preview_cb = SendWalkRPC
    return self:DoAction(buffered_action) -- movement prediction enabled
  end
end
